# ALISTAMIENTO ----

#Cargar librerías
library(dplyr)
library(readr)
library(stringr)
library(tidyr)
library(data.table)

# Cargar info
PROGRAMAS <- read_csv2("Entradas/Datos_programas.csv") %>% as.data.frame()
PAUTA <- read_csv2("Entradas/Consolidado_pauta_2022-20242S.csv") %>% as.data.frame()
FESTIVOS <- read_csv2("Entradas/Festivos Colombia 2010-2025.csv", col_names = F) %>% as.data.frame()

# Renombrar columnas
PAUTA <- rename(PAUTA,"Cod_ref"=colnames(PAUTA[2]),"HoraIni"=colnames(PAUTA[6]),"HoraFin"=colnames(PAUTA[7]),"CodPr"=colnames(PAUTA[13]),
             "Rat_num"=colnames(PAUTA[24]), "Rat_pct"=colnames(PAUTA[25]), "Durac_seg"=colnames(PAUTA[26]), Tipo_cial= "Tipo Comercial")
PROGRAMAS <- rename(PROGRAMAS, Programa="Título Programa", CodPr="Código programa", Rat_num="Rat#", Rat_pct="Rat%", shr="Shr%", TVR="TVR%")

FESTIVOS <- FESTIVOS %>% rename("Fecha"=X1) %>% mutate(Festivo=1)

# Transformaciones columnas para poderlas usar
PROGRAMAS$Hora_Ini <- substr(PROGRAMAS$`Timeband (Prg)`,1,8)
PROGRAMAS$Hora_Fin <- substr(PROGRAMAS$`Timeband (Prg)`,12,20)
PROGRAMAS$`Duración Prg (seg)` = (as.integer(substr(PROGRAMAS$`Duración Prg`,1,4))*60) + as.integer(substr(PROGRAMAS$`Duración Prg`,6,7))

# Incluir columna festivos en BD PROGRAMAS
PROGRAMAS <- left_join(PROGRAMAS, FESTIVOS, by="Fecha")
PROGRAMAS$Festivo <- replace(PROGRAMAS$Festivo, is.na(PROGRAMAS$Festivo), 0)
rm(FESTIVOS)


# Insertar agrupaciones personalizadas ----

# Incluir columnas en BD PROGRAMAS: hora inicio, min inicio, hora fin, min fin, año, mes y "weekday"
PROGRAMAS <- mutate(PROGRAMAS, hh=as.integer(substr(Hora_Ini,1,2)), mm=as.integer(substr(Hora_Ini,4,5)),
            hh_fin=as.integer(substr(Hora_Fin,1,2)), mm_fin=as.integer(substr(Hora_Fin,4,5)),
            Año=as.integer(substr(Fecha,7,11)), Mes=as.integer(substr(Fecha,4,5)),
            Fin_s_fest = ifelse((`Día Semana` %in% c('Sábado', 'Domingo') | Festivo==1), 1, 0),
            Fin_s_fest2 = ifelse(Fin_s_fest==1, 'Fin de semana/festivo','Día_hábil'))

# Incluir columnas en BD PAUTA: hora inicio
PAUTA <- mutate(PAUTA, hh=as.integer(substr(HoraIni,1,2)))

# Insertar franja horaria a partir de la hora de inicio del programa
PROGRAMAS <- mutate(PROGRAMAS, Franja = 
                    ifelse(Fin_s_fest == 1,
                           case_when(
                             hh < 12 ~ "6-Day (fs)",
                             hh < 18 ~ "7-Early (fs)",
                             hh < 22 ~ "8-Prime (fs)",
                             hh < 24 ~ "9-Late (fs)",
                             hh < 30 ~ "10-Overnight (fs)"),
                           case_when(
                             hh < 12 ~ "1-Day",
                             hh < 19 ~ "2-Early",
                             (hh < 22 | (hh==22 & mm<30)) ~ "3-Prime",
                             hh < 24 ~ "4-Late",
                             hh < 30 ~ "5-Overnight")))

# Agrupación de géneros
PROGRAMAS <- mutate(PROGRAMAS, Género2 = 
                    case_when(
                      Género == "CINE-PELICULA" | Género == "DOCUMENTALES" ~ "Cine",
                      Género == "CONCURSOS" | Género == "REALITY" ~ "Concurso",
                      Género == "DEPORTIVO" | Género == "REINADO" ~ "Evento en directo",
                      Género == "INFANTIL" ~ "Infantil",
                      Género == "LOTERIAS/SORTEOS" ~ "Sorteo",
                      Género == "OPINION/PERIODISTICO" | Género == "MAGAZIN" ~ "Magazín",
                      Género == "NOTICIERO" ~ "Noticiero",
                      Género == "TELENOVELA" | Género == "SERIES" | Género == "DRAMATIZADO" ~ "Serie/novela",
                      Género == "HUMOR" | Género == "MUSICAL" ~ "Humor/Musical",
                      Género == "OTROS" | Género == "TELEVENTAS" ~ "Otro",
                      Género == "NO APLICA" | Género == "NO COMERCIALIZABLE" ~ "NA"))

# Agrupación de canales
PROGRAMAS <- mutate(PROGRAMAS, Canal2 = case_when(
                  Canal %in% c("Canal Caracol", "Canal RCN", "Canal 1") ~ Canal,
                  Canal %in% c("Citytv","Canal Capital","Canal TRECE","Canal TRO","TeleAntioquia","TeleCafe","TeleCaribe","TeleMedellin","TelePacifico") ~ "Canales regionales/locales",
                  Canal %in% c("Senal Colombia","Institucional") ~ "Canales Nal Públicos"))

# Limpieza "entre programas"
PROGRAMAS <- filter(PROGRAMAS, !(grepl("ENTRE PROGRAMAS", PROGRAMAS$Programa)| grepl("ESPACIO SIN PROGRAMACION", PROGRAMAS$Programa)))

# Función para segmentar registros (crear uno por hora) si la duración del programa pasa de una hora a otra
time_diff_seconds <- function(start_time, end_time) {
#  as.numeric(as.ITime(end_time) - as.ITime(start_time))
  (as.integer(substr(end_time,4,5))-as.integer(substr(start_time,4,5)))*60 +
    (as.integer(substr(end_time,7,8))-as.integer(substr(start_time,7,8)))+1
}

duplicar_registros_dt <- function(dt) {
  setDT(dt)
  resultado <- list()
  
  for (i in seq_len(nrow(dt))) {
    hh <- dt$hh[i]
    hh_fin <- dt$hh_fin[i]
    Hora_Ini <- dt$Hora_Ini[i]
    Hora_Fin <- dt$Hora_Fin[i]
    dif <- hh_fin - hh
    
    if (hh_fin > hh) {
      fila_original <- dt[i]
      
      filas <- data.table(
        hh = seq(hh, hh_fin),
        Hora_Ini = c(Hora_Ini, paste0(sprintf("%02d", seq(hh + 1, hh_fin)), ":00:00")),
        Hora_Fin = c(paste0(sprintf("%02d", seq(hh, hh_fin - 1)), ":59:59"), Hora_Fin)
      )
      
      for (col in setdiff(names(dt), c("hh", "Hora_Ini", "Hora_Fin"))) {
        filas[[col]] <- fila_original[[col]]
      }
      
      filas[, `Duración Prg (seg)` := time_diff_seconds(Hora_Ini, Hora_Fin)]
      resultado[[i]] <- filas
      
    } else {
      resultado[[i]] <- dt[i]
    }
  }
  
  resultado <- rbindlist(resultado, fill=T)
  return(resultado)
}

PROGRAMAS2 <- duplicar_registros_dt(PROGRAMAS)

PROGRAMAS2 <- filter(PROGRAMAS2, `Duración Prg (seg)`>89)

PROGRAMAS3 <- PROGRAMAS2[, c("Año", "Mes", "Fecha", "Fin_s_fest", "Fin_s_fest2", "Canal", "Canal2", "Franja", "hh", "Timeband (Prg)",
                             "Hora_Ini", "Hora_Fin", "CodPr", "Programa", "Duración Prg (seg)", "Género2", "Rat_num", "Rat_pct")] %>%
                        arrange(Fecha, Canal, hh)

## Cruce BD programas con BD pauta

# Incluir variables de la pauta
PROGRAMAS3 <- left_join(PROGRAMAS3, PAUTA %>%
                       filter(Tipo_cial=="COMERCIAL") %>%
                       group_by(Fecha, Canal, Programa, hh) %>%
                       summarise(dur_pau=sum(Durac_seg), Inversión=sum(Inversión), Rat_prom_pau=mean(Rat_num), .groups='drop')) %>%
              mutate(dur_pau=replace_na(dur_pau,0), Inversión=replace_na(Inversión,0), Rat_prom_pau=replace_na(Rat_prom_pau,0),
                     ad_s_jt=round(dur_pau/`Duración Prg (seg)`,4))

ENTR_PR <- ENTR_PR %>%
           group_by(Fecha, Canal, hh) %>%
           summarise(`Duración Prg (seg)`=sum(`Duración Prg (seg)`), Rat_num=mean(Rat_num), Rat_pct=mean(Rat_pct), shr=mean(shr), .groups='drop')

ENTR_PR <- left_join(ENTR_PR, PAUTA %>%
                       filter(Tipo_cial=="COMERCIAL") %>%
                       group_by(Fecha, Canal, hh) %>%
                       summarise(dur_pau=sum(Durac_seg), Inversión=sum(Inversión), Rat_prom_pau=mean(Rat_num), .groups='drop'))

# Cálculo share del programa ----

# Calcula cuantos programas del mismo canal entran en el intervalo horario y establece un ponderador
PROGRAMAS3 <- left_join(PROGRAMAS3, PROGRAMAS3 %>%
                        group_by(Fecha, Canal, hh) %>%
                        summarise(num_pr=n_distinct(CodPr), Dur_prg_cn_frn=sum(`Duración Prg (seg)`), .groups = 'drop')) %>%
              group_by(Fecha, Canal, hh) %>% mutate(pr_num=row_number()) %>% ungroup() %>%
              mutate(w=`Duración Prg (seg)`/Dur_prg_cn_frn, Rat_pr_w=Rat_num*w)

# Calcula el share de cada programa dentro del intervalo horario (promedio ponderado si hay más de un programa en el mismo canal y hora)
PROGRAMAS3 <- merge(PROGRAMAS3, PROGRAMAS3 %>%
                   group_by(Fecha, hh) %>%
                   summarise(total_rat_hh = sum(Rat_pr_w), .groups = 'drop')) %>%
              mutate(shr_c = 100*Rat_pr_w/total_rat_hh) %>%
              arrange(PROGRAMAS3, Fecha, hh, Canal, pr_num)

# Variables adicionales
### Periodo
PROGRAMAS3$ID <- paste(PROGRAMAS3$Fecha, PROGRAMAS3$hh, PROGRAMAS3$pr_num, sep="-")

### Dummies Género
PROGRAMAS3$G_Cine <- ifelse(PROGRAMAS3$Género2 == "Cine", 1, 0)
PROGRAMAS3$G_Conc <- ifelse(PROGRAMAS3$Género2 == "Concurso", 1, 0)
PROGRAMAS3$G_EvDt <- ifelse(PROGRAMAS3$Género2 == "Evento en directo", 1, 0)
PROGRAMAS3$G_Infa <- ifelse(PROGRAMAS3$Género2 == "Infantil", 1, 0)
PROGRAMAS3$G_Sort <- ifelse(PROGRAMAS3$Género2 == "Sorteo", 1, 0)
PROGRAMAS3$G_Maga <- ifelse(PROGRAMAS3$Género2 == "Magazín", 1, 0)
PROGRAMAS3$G_Noti <- ifelse(PROGRAMAS3$Género2 == "Noticiero", 1, 0)
PROGRAMAS3$G_SerN <- ifelse(PROGRAMAS3$Género2 == "Serie/novela", 1, 0)
PROGRAMAS3$G_HuMu <- ifelse(PROGRAMAS3$Género2 == "Humor/Musical", 1, 0)

### Dummy weekday
PROGRAMAS3 <- mutate(PROGRAMAS3, weekday=ifelse(Fin_s_fest==1,0,1))

# Variable Duración programa
PROGRAMAS3 <- mutate(PROGRAMAS3, Dur_prg_30mm = ifelse(`Duración Prg (seg)`>(28*60), 1, 0))

# Cambio nombre a share
PROGRAMAS3 <- rename(PROGRAMAS3, s_jt=shr_c)


# REGRESIONES ----
# 1. Demanda de las audiencias (contenido) ----
# EQ1: ln(s_jt)-ln(s_0t) = [const +] a*ad_s_jt + b1*fun_jt + b2*poly_jt + b3*long_jt + y1*weekday_t + e1_jt


# Incluir s_0t (share otros canales) ----
PROGRAMAS3_1 <- left_join(PROGRAMAS3, PROGRAMAS3 %>%
                          mutate(s_0t = ifelse(Canal2 %in% c("Canales regionales/locales","Canales Nal Públicos"), s_jt, 0)) %>%
                          group_by(Fecha, hh) %>%
                          mutate(s_0t = sum(s_0t)))


# Y=ln(s_jt)-ln(s_0t) ----
PROGRAMAS3_1 <- filter(PROGRAMAS3_1, s_jt>0.5 & s_0t>0.1)
PROGRAMAS3_1$Y <- log(PROGRAMAS3_1$s_jt)-log(PROGRAMAS3_1$s_0t)
summary(PROGRAMAS3_1$Y)


# Calculo regresión ----

reg_cont <- lm(Y ~ d_s_jt + G_Cine + G_Conc + G_EvDt + G_Infa + G_Sort + G_Maga + G_Noti + G_SerN + G_HuMu + Dur_prg_30mm + weekday + Mes, data=PROGRAMAS3_1)
summary(reg_cont)


# 2. Demanda de los anunciantes (pauta) ----

# EQ2: ln(p_jt) = [const +] l1*ad_q_jt + lr*rate_jt + lf*fun_jt + lp*poly_jt + lk*kino_jt + ll*long_jt + y2*weekday_t + e2_jt

PROGRAMAS3_1 <- PROGRAMAS3_1 %>%
       rename(p_jt=Inversión, ad_q_jt=dur_pau, rate_jt=Rat_num) %>%
       mutate(p_jt=p_jt/ifelse(Año==2023, 1.1312, ifelse(Año==2024, 1.1312*1.0928, 1))) #Deflactor IPC del año anterior para convertir a $const 2022

PROGRAMAS3_1 <- filter(PROGRAMAS3_1, p_jt>0)

# Calculo regresión ----
reg_paut <- lm(log(p_jt) ~ ad_q_jt + rate_jt + G_Cine + G_Conc + G_EvDt + G_Infa + G_Sort + G_Maga + G_Noti + G_SerN + G_HuMu	+ Dur_prg_30mm + weekday + Mes, data=PROGRAMAS3_1)
summary(reg_paut)
